/**
 * @file main.cpp
 * @author Jonnie Walker iTE
 * @brief  ESP32-C6_PLC-Test
 * @version 0.2
 * @date 2024-05-20
 * 
 * @copyright Copyright (c) 2024
 * 
 * --------------------------------------------------------------------/
 * Core control is ESP32-C6-mode-N4
 *
 * Functions:
 * Description: The control board realizes the function of 4 outputs and 4 inputs
 * 1. Port of the control relay is closed
 * 2. Detect the input signal
 *
 * Note:
 * Use the serial port tool to view the specific output information!
 * 
 */
#include<Arduino.h>
//#include <ArduinoOTA.h> // LAN OTA upgrade
//#include <WiFi.h>
//#include "esp_sleep.h"
#include "TaskScheduler.h"


//OUTPUT  Terminal
#define RELAY_CN1_OUT1_PIN  10
#define RELAY_CN2_OUT2_PIN  11
#define RELAY_CN3_OUT3_PIN  22
#define RELAY_CN4_OUT4_PIN  23

//INPUT PIC Terminal
#define PCI_IN1_PIN 1
#define PCI_IN2_PIN 2
#define PCI_IN3_PIN 3
#define PCI_IN4_PIN 15

#define BUTTON_PIN 9  // The user presses the button

#define RUN_LED  8
uint8_t value_in1,value_in2,value_in3,value_in4;

// Function prototype declaration
void blinkLED();
void printMessage();

// Define tasks and schedulers
Scheduler ts; 
Task t1(4000 * TASK_MILLISECOND, TASK_FOREVER, &blinkLED, &ts, true);
Task t2(1000 * TASK_MILLISECOND, TASK_FOREVER, &printMessage, &ts, true);


void relay_out_control_ON(String prot_on);
void relay_out_control_OFF(String prot_off);
void pic_in_signal_read(String prot_p);

void mutual_4_4control(uint8_t target);
void port_8_Test();

void setup() {
  Serial.begin(115200);
 
  //Control output
  pinMode(RELAY_CN1_OUT1_PIN,OUTPUT);
  pinMode(RELAY_CN2_OUT2_PIN,OUTPUT);
  pinMode(RELAY_CN3_OUT3_PIN,OUTPUT);
  pinMode(RELAY_CN4_OUT4_PIN,OUTPUT);
 
  //signal input terminal，INPUT_PULLUP
  pinMode(PCI_IN1_PIN,INPUT_PULLUP);
  pinMode(PCI_IN2_PIN,INPUT_PULLUP);
  pinMode(PCI_IN3_PIN,INPUT_PULLUP);
  pinMode(PCI_IN4_PIN,INPUT_PULLUP);
  
  pinMode(BUTTON_PIN,INPUT);
  pinMode(RUN_LED,OUTPUT);
 
  port_8_Test();// Self-test

 Serial.println("init esp32-c6-plc-------!");
}

void loop() {
 ts.execute();
}



// Task 1:
void blinkLED() {
  
  static bool ledState = false;
  digitalWrite(RUN_LED, ledState ? HIGH : LOW);
  ledState = !ledState;
  
  
  pic_in_signal_read("IN-S"); // Read input signals from 4 ports

 // Serial.println("task1-------------/");
}

// Task 2: Print a message through a serial port
void printMessage() {
  int value =1;
  for(int vlue_t = 1;vlue_t <=4;value ++){
     mutual_4_4control(vlue_t);// Check ports 1 to 4 for signal input. If there is signal input, open the relay
  }
  
  
   if (Serial.available() > 0) { 
    char data = Serial.read(); 
    Serial.print("Received: ");
    Serial.println(data); 
    if(data == 'A'){
     relay_out_control_ON("CN1");
     Serial.println("CON1--------------------/");
    }
    else if(data == 'B'){
       relay_out_control_ON("CN2");
       Serial.println("CON2--------------------/");
    }
    else if(data == 'C'){
     
       relay_out_control_ON("CN3");
      Serial.println("CON3--------------------/");
    }
    else if(data == 'D'){
      relay_out_control_ON("CN4");
      Serial.println("CON4--------------------/");
    }
    else if (data == 'E'){
      relay_out_control_OFF("OFF");
      Serial.println("Close all ports--------------------/");
    }
    else{
       Serial.println("QSZNTEC");
      Serial.println("Thank you for using our board, 2024-5-17 production. My name is JW_ITEM !");
      Serial.println("ESP32-C6-PLC-DEBUG!");
    }
  }

 
  value = digitalRead(BUTTON_PIN);
  if(value == 0){
    Serial.println("Button -D9--- !");
  }

 // Serial.println("Task2!------------/");
}



// Mutual control
// Description:
void mutual_4_4control(uint8_t target){
 switch (target)
 {
 case 1:
    pic_in_signal_read("IN1");
    if(value_in1 == 0){       // If there is a signal input, turn on the switch 1
      relay_out_control_ON("CN1");
    }
    else{  // Otherwise close
      relay_out_control_OFF("CN1");
    }
  break;
  case 2:
    pic_in_signal_read("IN2");
    if(value_in2 == 0){
      relay_out_control_ON("CN2");
    }
    else{
      relay_out_control_OFF("CN2");
    }
   break;
  case 3:
    pic_in_signal_read("IN3");
    if(value_in3 == 0){
      relay_out_control_ON("CN3");
    }
     else{
      relay_out_control_OFF("CN3");
    }
    break;
  case 4:
    pic_in_signal_read("IN4");
    if(value_in4 == 0){
      relay_out_control_ON("CN4");
    }
    else{
      relay_out_control_OFF("CN4");
    }
    break;
 
 //default:
  //break;
 }


}

// Start the self-test
void port_8_Test(){
   relay_out_control_ON("SC-ON");// Open once
   delay(500);
   relay_out_control_OFF("SC-OFF");
   

   pic_in_signal_read("IN-S"); // Read signals from four ports

}

//prot_on:
//use:relay_out_control_ON("CN1");
void relay_out_control_ON(String prot_on){
  if (prot_on == "CN1") {
     digitalWrite(RELAY_CN1_OUT1_PIN,HIGH);
    Serial.println("CN1---TURN ON---!");
  } else if (prot_on == "CN2") {
    digitalWrite(RELAY_CN2_OUT2_PIN,HIGH);
     Serial.println("CN2---TURN ON---!");
  } else if (prot_on == "CN3") {
    digitalWrite(RELAY_CN3_OUT3_PIN,HIGH);
     Serial.println("CN3---TURN ON---!");
  } else if (prot_on == "CN4") {
    digitalWrite(RELAY_CN4_OUT4_PIN,HIGH);
     Serial.println("CN4---TURN ON---!");
  } else if (prot_on == "ON") {// Open all at the same time
    digitalWrite(RELAY_CN1_OUT1_PIN,HIGH);
     digitalWrite(RELAY_CN2_OUT2_PIN,HIGH);
     digitalWrite(RELAY_CN3_OUT3_PIN,HIGH);
     digitalWrite(RELAY_CN4_OUT4_PIN,HIGH);
  } else if (prot_on == "SC-ON") {
    digitalWrite(RELAY_CN1_OUT1_PIN,HIGH);
     delay(200);
     digitalWrite(RELAY_CN2_OUT2_PIN,HIGH);
     delay(200);
     digitalWrite(RELAY_CN3_OUT3_PIN,HIGH);
     delay(200);
     digitalWrite(RELAY_CN4_OUT4_PIN,HIGH);
     delay(200);
     Serial.println("Relay init turn on -----!");
  } else {
    Serial.println("Invalid command!");
  }
}




//prot_off:
//use:relay_out_control_OFF("CN1");
void relay_out_control_OFF(String prot_off){
  if (prot_off == "CN1") {
    digitalWrite(RELAY_CN1_OUT1_PIN, LOW);
    Serial.println("CN1---TURN OFF---!");
  } else if (prot_off == "CN2") {
    digitalWrite(RELAY_CN2_OUT2_PIN, LOW);
    Serial.println("CN2---TURN OFF---!");
  } else if (prot_off == "CN3") {
    digitalWrite(RELAY_CN3_OUT3_PIN, LOW);
    Serial.println("CN3---TURN OFF---!");
  } else if (prot_off == "CN4") {
    digitalWrite(RELAY_CN4_OUT4_PIN, LOW);
    Serial.println("CN4---TURN OFF---!");
  } else if (prot_off == "OFF") {
    digitalWrite(RELAY_CN1_OUT1_PIN, LOW);
    digitalWrite(RELAY_CN2_OUT2_PIN, LOW);
    digitalWrite(RELAY_CN3_OUT3_PIN, LOW);
    digitalWrite(RELAY_CN4_OUT4_PIN, LOW);
    Serial.println("All relays OFF!");
  } else if (prot_off == "SC-OFF") {
    digitalWrite(RELAY_CN1_OUT1_PIN, LOW);
    delay(200);
    digitalWrite(RELAY_CN2_OUT2_PIN, LOW);
    delay(200);
    digitalWrite(RELAY_CN3_OUT3_PIN, LOW);
    delay(200);
    digitalWrite(RELAY_CN4_OUT4_PIN, LOW);
    delay(200);
    Serial.println("Sequential relays OFF!");
  } else {
    Serial.println("Invalid command!");
  }
}

//prot_p:
//use:pic_in_signal_read("IN1");
void pic_in_signal_read(String prot_p){
  if(prot_p == "IN1") {
    value_in1 = digitalRead(PCI_IN1_PIN);
  } 
  else if (prot_p == "IN2") {
    value_in2 = digitalRead(PCI_IN2_PIN);
  } 
  else if (prot_p == "IN3") {
    value_in3 = digitalRead(PCI_IN3_PIN);
  } 
  else if (prot_p == "IN4") {
    value_in4 = digitalRead(PCI_IN4_PIN);
  } 
  else if (prot_p == "IN-S") {
    value_in1 = digitalRead(PCI_IN1_PIN);
      Serial.println("Read data from 4 ports!");
      Serial.print("IN1 : ");
      Serial.println(value_in1);
      delay(100);
      value_in2 = digitalRead(PCI_IN2_PIN);
      Serial.print("IN2 : ");
      Serial.println(value_in2);
      delay(100);
      value_in3 = digitalRead(PCI_IN3_PIN);
      Serial.print("IN3 : ");
      Serial.println(value_in3);
      delay(100);
      value_in4 = digitalRead(PCI_IN4_PIN);
      Serial.print("IN4 : ");
      Serial.println(value_in4); 
  }
 
}





